// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Instack.pas' rev: 10.00

#ifndef InstackHPP
#define InstackHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Inexception.hpp>	// Pascal unit
#include <Instackconsts.hpp>	// Pascal unit
#include <Inglobal.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Instack
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS EIdSocketError;
class PASCALIMPLEMENTATION EIdSocketError : public Inexception::EInException 
{
	typedef Inexception::EInException inherited;
	
private:
	int FLastError;
	
public:
	__fastcall virtual EIdSocketError(const int AErr, const AnsiString AMsg);
	__property int LastError = {read=FLastError, nodefault};
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EIdSocketError(AnsiString AMsg)/* overload */ : Inexception::EInException(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EIdSocketError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : Inexception::EInException(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EIdSocketError(int Ident)/* overload */ : Inexception::EInException(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EIdSocketError(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : Inexception::EInException(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EIdSocketError(const AnsiString Msg, int AHelpContext) : Inexception::EInException(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EIdSocketError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : Inexception::EInException(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EIdSocketError(int Ident, int AHelpContext)/* overload */ : Inexception::EInException(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EIdSocketError(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : Inexception::EInException(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EIdSocketError(void) { }
	#pragma option pop
	
};


typedef TMetaClass* TIdSocketListClass;

class DELPHICLASS TIdSocketList;
class PASCALIMPLEMENTATION TIdSocketList : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	int operator[](int AIndex) { return Items[AIndex]; }
	
protected:
	Inglobal::TIdCriticalSection* FLock;
	virtual int __fastcall GetItem(int AIndex) = 0 ;
	
public:
	__fastcall virtual TIdSocketList(void);
	__fastcall virtual ~TIdSocketList(void);
	virtual void __fastcall Add(int AHandle) = 0 ;
	virtual TIdSocketList* __fastcall Clone(void) = 0 ;
	virtual int __fastcall Count(void) = 0 ;
	/*         class method */ static TIdSocketList* __fastcall CreateSocketList(TMetaClass* vmt);
	__property int Items[int AIndex] = {read=GetItem/*, default*/};
	virtual void __fastcall Remove(int AHandle) = 0 ;
	virtual void __fastcall Clear(void) = 0 ;
	virtual bool __fastcall Contains(int AHandle) = 0 ;
	void __fastcall Lock(void);
	#pragma option push -w-inl
	/* virtual class method */ virtual bool __fastcall Select(TIdSocketList* AReadList, TIdSocketList* AWriteList, TIdSocketList* AExceptList, const int ATimeout = 0xfffffffe) { return Select(__classid(TIdSocketList), AReadList, AWriteList, AExceptList, ATimeout); }
	#pragma option pop
	/*         class method */ static bool __fastcall Select(TMetaClass* vmt, TIdSocketList* AReadList, TIdSocketList* AWriteList, TIdSocketList* AExceptList, const int ATimeout = 0xfffffffe);
	virtual bool __fastcall SelectRead(const int ATimeout = 0xfffffffe) = 0 ;
	virtual bool __fastcall SelectReadList(TIdSocketList* &VSocketList, const int ATimeout = 0xfffffffe) = 0 ;
	void __fastcall Unlock(void);
};


class DELPHICLASS TInStack;
class PASCALIMPLEMENTATION TInStack : public System::TObject 
{
	typedef System::TObject inherited;
	
protected:
	AnsiString FHostName;
	AnsiString FLocalAddress;
	Classes::TStrings* FLocalAddresses;
	virtual AnsiString __fastcall HostByName(const AnsiString AHostName, const Inglobal::TIdIPVersion AIPVersion = (Inglobal::TIdIPVersion)(0x0)) = 0 ;
	AnsiString __fastcall MakeCanonicalIPv6Address(const AnsiString AAddr);
	virtual AnsiString __fastcall ReadHostName(void) = 0 ;
	virtual void __fastcall PopulateLocalAddresses(void) = 0 ;
	virtual AnsiString __fastcall GetLocalAddress(void) = 0 ;
	virtual Classes::TStrings* __fastcall GetLocalAddresses(void) = 0 ;
	
public:
	virtual int __fastcall Accept(int ASocket, AnsiString &VIP, int &VPort, const Inglobal::TIdIPVersion AIPVersion = (Inglobal::TIdIPVersion)(0x0)) = 0 ;
	virtual void __fastcall Bind(int ASocket, const AnsiString AIP, const int APort, const Inglobal::TIdIPVersion AIPVersion = (Inglobal::TIdIPVersion)(0x0)) = 0 ;
	virtual void __fastcall Connect(const int ASocket, const AnsiString AIP, const int APort, const Inglobal::TIdIPVersion AIPVersion = (Inglobal::TIdIPVersion)(0x0)) = 0 ;
	__fastcall virtual TInStack(void);
	virtual void __fastcall Disconnect(int ASocket) = 0 ;
	/*         class method */ static void __fastcall Make(TMetaClass* vmt);
	virtual void __fastcall GetPeerName(int ASocket, AnsiString &VIP, int &VPort) = 0 ;
	virtual void __fastcall GetSocketName(int ASocket, AnsiString &VIP, int &VPort) = 0 ;
	virtual AnsiString __fastcall HostByAddress(const AnsiString AAddress, const Inglobal::TIdIPVersion AIPVersion = (Inglobal::TIdIPVersion)(0x0)) = 0 ;
	virtual Word __fastcall HostToNetwork(Word AValue) = 0 /* overload */;
	virtual unsigned __fastcall HostToNetwork(unsigned AValue) = 0 /* overload */;
	virtual __int64 __fastcall HostToNetwork(__int64 AValue) = 0 /* overload */;
	bool __fastcall IsIP(AnsiString AIP);
	virtual void __fastcall Listen(int ASocket, int ABackLog) = 0 ;
	virtual int __fastcall NewSocketHandle(const int ASocketType, const int AProtocol, const Inglobal::TIdIPVersion AIPVersion = (Inglobal::TIdIPVersion)(0x0), const bool AOverlapped = false) = 0 ;
	virtual Word __fastcall NetworkToHost(Word AValue) = 0 /* overload */;
	virtual unsigned __fastcall NetworkToHost(unsigned AValue) = 0 /* overload */;
	virtual __int64 __fastcall NetworkToHost(__int64 AValue) = 0 /* overload */;
	virtual void __fastcall GetSocketOption(int ASocket, int ALevel, int AOptName, /* out */ int &AOptVal) = 0 ;
	virtual void __fastcall SetSocketOption(int ASocket, int ALevel, int AOptName, int AOptVal) = 0 /* overload */;
	AnsiString __fastcall ResolveHost(const AnsiString AHost, const Inglobal::TIdIPVersion AIPVersion = (Inglobal::TIdIPVersion)(0x0));
	virtual int __fastcall Receive(int ASocket, Inglobal::TBytes &VBuffer) = 0 ;
	virtual int __fastcall Send(int ASocket, const Inglobal::TBytes ABuffer, int AOffset = 0x0, int ASize = 0xffffffff) = 0 ;
	virtual int __fastcall ReceiveFrom(int ASocket, Inglobal::TBytes &VBuffer, AnsiString &VIP, int &VPort, const Inglobal::TIdIPVersion AIPVersion = (Inglobal::TIdIPVersion)(0x0)) = 0 ;
	virtual int __fastcall SendTo(int ASocket, const Inglobal::TBytes ABuffer, const int AOffset, const AnsiString AIP, const int APort, const Inglobal::TIdIPVersion AIPVersion = (Inglobal::TIdIPVersion)(0x0)) = 0 ;
	virtual bool __fastcall SupportsIPv6(void) = 0 ;
	__property AnsiString HostName = {read=FHostName};
	__property AnsiString LocalAddress = {read=GetLocalAddress};
	__property Classes::TStrings* LocalAddresses = {read=GetLocalAddresses};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TInStack(void) { }
	#pragma option pop
	
};


typedef TMetaClass* TInStackClass;

//-- var, const, procedure ---------------------------------------------------
extern PACKAGE TInStack* GStack;
extern PACKAGE TMetaClass* GSocketListClass;
extern PACKAGE TInStack* __fastcall InStackFactory(void);

}	/* namespace Instack */
using namespace Instack;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Instack
